/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: $
   Last Modification:
    $Author: stephans $
    $Modtime: $
    $Revision: 2581 $
   
   Targets:
     MQX   : yes
 
   Description:
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     1         01.03.2011  SS       Initial version
     
**************************************************************************************/
#include <mqx.h>
#include <bsp.h>
#include <shell.h>
#include <stdint.h>
#include <string.h>
#include "main.h"
#include "CIFXErrors.h"
#include "ToolkitSample.h"

int32_t cifXShellCommands(int_32 argc, char_ptr argv[]);

const SHELL_COMMAND_STRUCT Shell_commands[] = 
{
   /* cifX API demo commands */
   { "enumboarddemo", cifXShellCommands },      
   { "sysdevicedemo", cifXShellCommands },      
   { "channeldemo",   cifXShellCommands },      
   { "blockdemo",     cifXShellCommands },      
   /* Basic commands */
   { "exit",          Shell_exit },      
   { "help",          Shell_help }, 
   { "?",             Shell_command_list },
   { NULL,            NULL },
};

TASK_TEMPLATE_STRUCT MQX_template_list[] =
{
/*  Task number,      Entry point,            Stack, Pri, String, Auto? */
   {MAIN_TASK,        Main_task,              8000,  9,   "main", MQX_AUTO_START_TASK},
   {CIFXPOLLING_TASK, cifXPollingThread,      255,   10,  "cifx", 0                  },
   {CIFXISR_TASK,     InterruptServiceThread, 255,   10,  "isr ", 0                  },
   {0,                0,                        0,   0 ,  0     , 0                  }
};

/*****************************************************************************/
/*! cifX Shell command dispatcher
*   \return 0                                                                */
/*****************************************************************************/
int32_t cifXShellCommands(int_32 argc, char_ptr argv[])
{
  unsigned long fShort  = 0;

  if (Shell_check_help_request(argc, argv, &fShort))
  {
    if (0 == strcmp(argv[0], "enumboarddemo"))
      printf("enumboarddemo - Enumerates available cifX devices \r\n");
    else if (0 == strcmp(argv[0], "sysdevicedemo"))
      printf("sysdevicedemo - Demonstrates packet transfer via system device \r\n");
    else if (0 == strcmp(argv[0], "channeldemo"))
      printf("channeldemo   - Demonstrates packet/IO transfer via communication channel \r\n");
    else if (0 == strcmp(argv[0], "blockdemo"))
      printf("blockdemo     - Demonstrate control/status block functionality\r\n");
    return 0;
  }
  
  if (0 == strcmp(argv[0], "enumboarddemo"))
    EnumBoardDemo();
  else if (0 == strcmp(argv[0], "sysdevicedemo"))
    SysdeviceDemo();
  else if (0 == strcmp(argv[0], "channeldemo"))
    ChannelDemo();
  else if (0 == strcmp(argv[0], "blockdemo"))
    BlockDemo();

  return 0;
}

/*****************************************************************************/
/*! This task initializes cifXToolkit and starts SHELL.
*   \return 0                                                                */
/*****************************************************************************/
void Main_task(uint_32 initial_data)
{ 
   /* cifXToolkit init */
   if (CIFX_NO_ERROR == cifXToolkitInit())
   {
      EnumBoardDemo();
      SysdeviceDemo();
      ChannelDemo();
      BlockDemo();
   }     
   
   for (;;)  
   {
      /* Run the shell */
      Shell(Shell_commands, NULL);
      printf("Shell exited, restarting...\n");
   }
}
